/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.dto.CtAccountDto;

/**
 * AJEge[u𑀍@\񋟂B<br><br>
 * {@link CtAccountDto}pāADBJavavOԂŃR[hLB<br>
 */
public class CtAccountDao extends BaseDao {
	
	// e[uyуL[
	/**
	 *  AJEge[uB<br>
	 */
	public static final String TABLE  = "CT_ACCOUNT";
	
	/**
	 *  AJEge[uAL[B<br>
	 */
	public static final String KEY_01 = "USER_ID";
	
	// 
	/**
	 *  AJEge[uA([U[ID)B<br>
	 */
	public static final String COL_USER_ID = "USER_ID";

	/**
	 *  AJEge[uA(s)B<br>
	 */
	public static final String COL_ATTEMPT = "ATTEMPT";
	
	/**
	 * RXgN^B<br>
	 */
	public CtAccountDao() {
		super();
		INSERT_DATE = "";
		INSERT_USER = "";
		UPDATE_DATE = "UPDATE_DATE";
		UPDATE_USER = "";
	}
	
	/**
	 * RXgN^B<br>
	 * @param cfg     ݒt@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 * @param conn    DBRlNV
	 */
	public CtAccountDao(
			Properties   cfg,
			String       cmd,
			CmAspUserDto aspUser,
			CmUserDto    user,
			Connection   conn
	) {
		this();
		initDao(cfg, cmd, aspUser, user, conn);
	}
	
	/**
	 * ʎ擾(DTOList)B<br>
	 * @return Xg
	 * @throws SQLException
	 */
	private List<CtAccountDto> mappingAll() throws SQLException {
		List<CtAccountDto> all = new ArrayList<CtAccountDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	
	/**
	 * ʎ擾(DTO)B<br>
	 * @return
	 * @throws SQLException
	 */
	private CtAccountDto mapping() throws SQLException {
		CtAccountDto dto = new CtAccountDto();
		dto.setUserId(rs.getString(COL_USER_ID));
		dto.setAttempt(rs.getInt(COL_ATTEMPT));
		mappingCommonInfo(dto);
		return dto;
	}
	
	
	/**
	 * Sf[^擾B<br>
	 * @return (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CtAccountDto> findAllCtAccount() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	
	/**
	 * L[ɂf[^擾B<br>
	 * @param userId [U[ID(L[)
	 * @return (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CtAccountDto findCtAccountForUserId(String userId) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, userId);
			executeQuery();
			CtAccountDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * f[^}B<br>
	 * @param dto }ΏDTO
	 * @return }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public int insert(CtAccountDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParam(index++, dto.getUserId());
			setParam(index++, dto.getAttempt());
			setCommonParams(true);
			executeUpdate(false);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * f[^XVB<br>
	 * @param dto XVΏDTO
	 * @return XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public int update(CtAccountDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParam(index++, dto.getUserId());
			setParam(index++, dto.getAttempt());
			setCommonParams(false);
			setParam(index++, dto.getUserId());
			executeUpdate(false);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
}
